*******************************************************************************
*                          680xx Grundprogramm edit1                          *
*                          (C) 1990 Ralph Dombrowski                          *
*                             2008 Jens Mewes                                 *
*                                 Rev 7.10                                    *
*                                01.01.2008                                   *
*                              Editor Teil 1                                  *
*******************************************************************************


blkstart equ $81                * Zeichen fr Blockstart
blkende  equ $82                * Zeichen fr Blockende
blkins   equ $83                * Zeichen fr Ziel

edit:
 move.b optflag(a5),-(a7)       * Schrifart sichern
 move.b cotempo(a5),-(a7)       * Hardscrolltempo sichern
 clr.b cotempo(a5)              * Software-Scroll
 clr.b ausbuf(a5)               * Kein Suchen oder Ersetzen
 and.b #$f9,insl(a5)            * Keine Blockmarkierungen
 move.l stxtxt(a5),akttxt(a5)   * Anfangsadresse
 bsr getscreen                  * Bildschirm holen
editlp:
 bsr ci
 cmp.b #$7f,d0                  * Zeichen fr Delete
 bne.s edit2                    * Nein, weiter
 move.b curx(a5),d0
 cmp.b lrand(a5),d0             * Cursor ganz links
 beq editlp                     * Ja, dann kein Lschen
 subq.b #1,curx(a5)             * Cursor zurck
 bsr delchar                    * Zeichen lschen
bra.s editlp
edit2:
 cmp.b #' ',d0                  * Kleiner als ' ' ?
 bcs.s edit4                    * Dann Ctrl-Zeichen
 btst.b #0,insl(a5)
 beq.s edit3
 bsr inschar                    * Bei Einfgemode Zeichen einfgen
edit3:
 bsr getcode                    * Gegebenenfalls in deutsches Zeichen wandeln
 bsr charoscr                   * Zeichen ausgeben
 cmp.b #'',(a0)                * Wenn $7f am Anfang einer Zeile
 bne.s editlp
 move.b curx(a5),d4             * Dann mu es gelscht werden
 clr.b curx(a5)
 moveq #' ',d0                  * Falls ein Zeichen eingegeben wird, wird
 bsr charoscr                   * die Zeile automatisch aktiv
 move.b d4,curx(a5)
bra.s editlp

edit4:
 cmp #27,d0                     * Grer als Ctrl-Z ?
 bhi.s editlp                   * Dann zurck
 add    d0,d0
 move edittab(pc,d0.w),d0
 jsr edittab(pc,d0)             * Unterprogramm aufrufen
bra.s editlp

edittab:
 dc.w carset-edittab
 dc.w editcta-edittab           * Ctrl-A (Wort links)
 dc.w carset-edittab
 dc.w screenup-edittab          * Ctrl-C (Seite vor)
 dc.w editctd-edittab           * Ctrl-D (Zeichen rechts)
 dc.w editcte-edittab           * Ctrl-E (Zeichen hoch)
 dc.w editctf-edittab           * Ctrl-F (Wort rechts)
 dc.w delchar-edittab           * Ctrl-G (Zeichen lschen)
 dc.w editcts-edittab           * Ctrl-H (Ein Zeichen zurck)
 dc.w editcti-edittab           * Ctrl-I (Auf Tab rechts)
 dc.w editctj-edittab           * Ctrl-J (Befehlsverzeichnis)
 dc.w editctk-edittab           * Ctrl-K (Spezielle Befehle)
 dc.w editctl-edittab           * Ctrl-L (Ctrl-QA und Ctrl-QF wiederholen)
 dc.w editctm-edittab           * Ctrl-M (Carriage Return)
 dc.w editctn-edittab           * Ctrl-N (Zeile einfgen)
 dc.w editcto-edittab           * Ctrl-O (Auf Tab links)
 dc.w editctp-edittab           * Ctrl-P (Zeichensatz ndern)
 dc.w editctq-edittab           * Ctrl-Q (Spezielle Befehle)
 dc.w screendown-edittab        * Ctrl-R (Seite zurck)
 dc.w editcts-edittab           * Ctrl-S (Zeichen links)
 dc.w eraeoln-edittab           * Ctrl-T (Lschen rechts)
 dc.w inschar-edittab           * Ctrl-U (Ein Zeichen einfgen)
 dc.w editctv-edittab           * Ctrl-V (Einfgemode umschalten)
 dc.w editctw-edittab           * Ctrl-W (Zeile ab)
 dc.w editctx-edittab           * Ctrl-X (Cursor runter)
 dc.w editcty-edittab           * Ctrl-Y (Zeile lschen)
 dc.w editctz-edittab           * Ctrl-Z (Zeile hoch)
 dc.w editesc-edittab           * ESC-Funktionen

editcta:                        * Ctrl-A
 move.b lrand(a5),d1
editcta0:
 cmp.b curx(a5),d1              * Cursor am Anfang der Zeile ?
 beq editcts1                   * Ja, dann nur ans Ende der letzen Zeile
 subq.b #1,curx(a5)             * Sonst Cursor zurck
 bsr calccur
 cmp.b #' ',(a2)                * Bei Leerzeichen wiederholen
 beq.s editcta
editcta1:
 cmp.b curx(a5),d1              * Ende, wenn am Zeilenanfang
 beq carset
 subq.b #1,curx(a5)             * Cursor zurck
 cmp.b #' ',-(a2)               * Bis Leerzeichen wiederholen
bne.s editcta1
                                * Jetzt wieder ein Zeichen nach rechts

editctd:                        * Ctrl-D
 bsr curright                   * Cursor um ein Zeichen nach rechts und testen
 bcs.s editctd1                 * Hinter letzem Zeichen, deshalb nchste Zeile
rts
editctd1:
 move.b lrand(a5),curx(a5)      * Cursor auf linken Rand
bra editctx                     * Eine Zeile runter

editcte:                        * Ctrl-E
 tst.b cury(a5)                 * Weiter, wenn Cursor in oberster Zeile
 beq.s editcte1
 subq.b #1,cury(a5)             * Eine Zeile hoch
bra curtoend                    * Test der Cursorposition
editcte1:
 bsr crtdown                    * Scrollen
bra curtoend                    * Test der Cursorposition

editctf:                        * Ctrl-F
 bsr curright                   * Cursor um ein Zeichen nach rechts und testen
 bcs.s editctd1                 * Hinter letztem Zeichen, dann auf nchste Zeile
bra.s editctf2                  * Anfang Wort rechts suchen
editctf1:
 bsr curright                   * Cursor ein Zeichen nach rechts und testen
 bcs adjcurx                    * Ja, dann Endetest
editctf2:
 bsr calccur                    * Zeileninfo holen
 cmp.b #' ',(a2)
 beq.s editctf1                 * Suchen bis kein Leerzeichen mehr
 cmp.b #' ',-1(a2)
 beq carset                     * Leerzeichen vor Zeichen, dann OK
editctf3:
 bsr curright                   * Cursor ein Zeichen nach rechts und testen
 bcs adjcurx                    * Endetest, wenn hinter letztem Zeichen
 cmp.b #' ',1(a2)               * Wenn Leerzeichen folgt, dann von vorne
 bne.s editctf3                 * Sonst suchen, bis Leerzeichen
bra.s editctf

editcti:                        * Ctrl-I (Tab)
 lea    edittabs+1(a5),a0       * Adresse der Tabs
 moveq  #0,d0
 move.b curx(a5),d0             * Cursorposition
 adda.l d0,a0                   * Adresse des Tab
 clr    d1                      * Zhler fr Sprung
editcti0:
 addq   #1,d1                   * 1 weiter
 addq   #1,d0                   * Nchste Position
 cmp    #80,d0
 bne.s  editcti1                * Weiter, wenn nicht hinten
rts
editcti1:
 tst.b  (a0)+
 bpl.s  editcti0                * Weitersuchen, da nicht Tab
 btst.b #0,insl(a5)             * Einfgemode an ?
 beq.s editcti3                 * Nein, weiter
 move   d1,d0
editcti2:
 bsr inschar                    * Zeichen einfgen
 subq #1,d0
 bne.s editcti2                 * Bis Null erreicht
editcti3:
 add.b d1,curx(a5)              * Neue Cursorposition
bra adjcurx                     * Zeilenende-Test

editctj:                        * HELP
 moveq #%00110011,d0
 bsr setpage                    * Seite 3 zeigen
 bsr editci                     * Auf Taste warten
bra aktpage                     * Alte Seite

editctk:                        * Extrafunktionen
 bsr ci
 and #%11111,d0                 * Ctrl, Gro u5nd Kleinschreibung erlaubt
 cmp #26,d0
 bhi carset                     * Grer als 26 geht nicht
 add    d0,d0
 move edctktab(pc,d0.w),d0
jmp edctktab(pc,d0.w)           * Unterprogramm aufrufen

edctktab:
 dc.w carset-edctktab
 dc.w editka-edctktab           * Assembleraufruf (Nicht sinnvoll bei DOS)
 dc.w editkb-edctktab           * Block-Anfang markieren
 dc.w editkc-edctktab           * Block kopieren
 dc.w editkd-edctktab           * Block drucken
 dc.w carset-edctktab
 dc.w editkf-edctktab           * Einstellungen speichern
 dc.w editkg-edctktab           * Einstellungen laden
 dc.w markeweg-edctktab         * Marken lschen
 dc.w editki-edctktab           * Inhaltsverzeichnis
 dc.w carset-edctktab
 dc.w editkk-edctktab           * Block-Ende markieren
 dc.w editkl-edctktab           * Block von Disk lesen
 dc.w carset-edctktab
 dc.w carset-edctktab
 dc.w carset-edctktab
 dc.w editkp-edctktab           * Fontdaten laden
 dc.w editkq-edctktab           * Ende
 dc.w editkr-edctktab           * Block lesen
 dc.w editks-edctktab           * Block auf Disk speichern
 dc.w editkt-edctktab           * Text auf Disk
 dc.w carset-edctktab
 dc.w editkv-edctktab           * Block verschieben
 dc.w editkw-edctktab           * Block speichern
 dc.w editkx-edctktab           * Ende
 dc.w editky-edctktab           * Block lschen

editka:                         * Assembleraufruf
 bsr putscreen                  * Bildschirm abspeichern
 bsr assemble                   * Assembler aufrufen
 scs.b d7                       * Carry-Flag merken
 clr.b ausbuf(a5)               * Nach Assembleraufruf kein ^L mehr
 bsr editci
 tst.b d7
 bne editqr1                    * Assembler wurde abgebrochen
 tst errcnt(a5)                 * Wenn kein Fehler, dann Ende
 beq.s editka1
 movea.l errzeile(a5),a0        * Zeiger auf Fehler nach akttxt
 cmp.b #$a,(a0)+
 beq.s editka0                  * OK, $a bersprungen
 subq.l #1,a0                   * Es war nicht $a
editka0:
 move.l a0,akttxt(a5)           * Adresse merken
bra getscreen                   * Fehlerhafte Zeile ist erste Zeile im Screen

editka1:
 addq.l #4,a7                   * Stack reinigen
 bsr editkx1
 move.b (a7)+,cotempo(a5)       * Alte Geschwindigkeit
 move.b (a7)+,optflag(a5)       * Schrifart wiederherstellen
bra carset                      * Editor mit KA verlassen

editkb:                         * Block-Anfang setzen
 btst.b #1,insl(a5)             * Marke schon gesetzt ?
 beq.s editkb1                  * Nein, weiter
 bsr markeweg                   * Sonst alle Marken entfernen
editkb1:
 bset.b #1,insl(a5)             * Merker, da Marke gesetzt
 moveq #blkstart,d0             * Zeichen fr Block-Anfang
 bsr inschar                    * Zeichen einfgen
bra charoscr                    * Zeichen ausgeben

editkc:
 bsr.s editkc0                  * Block kopieren
 bcs carset
 cmpa.l a2,a3                   * Blockmarken hinter Screen
 bls.s editkc6                  * Ja, dann OK
 subq.l #2,a3                   * Sonst akttxt erniedrigen, da zwei Zeichen
editkc6:                        * entfernt werden
 move.l a1,akttxt(a5)           * Ziel
 lea 1(a1),a0                   * Block-Marke
 bsr clrram                     * Anfangsmarke vom Originalblock lschen
 lea -1(a2),a0                  * Ziel
 subq.l #2,a2                   * Block-Marke
 move.l a2,akttxt(a5)
 bsr clrram                     * Endmarke vom Originalblock lschen
bra editkv1                     * akttxt in Ordnung bringen und Screen lesen

editkc0:                        * Block kopieren
 move.b insl(a5),d0
 and.b #%110,d0
 cmp.b #%110,d0
 bne carset                     * Kein Block markiert
 bsr editadr                    * Adresse des Cursors holen
 move.b curx(a5),-(a7)
 move.b cury(a5),-(a7)
 bsr savescreen                 * Screen in Speicher
 bsr getblock                   * Block-Adressen holen
 bcs editkc5                    * Fehler
 addq.l #1,a2                   * Blockende-Marke auch mit nehmen
 cmpa.l a3,a1                   * Wenn Ziel innerhalb des
 bpl.s editkc1                  * Blocks liegt
 cmpa.l a3,a2                   * so erfolgt
 bpl.s editkc5                  * Abbruch
editkc1:
 addq.l #4,a7                   * a1 = Anfang
 move.l a3,akttxt(a5)           * a2 = Ende
 move.l a2,d0                   * a3 = Ziel
 sub.l a1,d0                    * Anzahl der einzufgenden Zeichen
 cmp.b #blkins,(a3)             * Wenn Ins-Marke vorhanden ist, wird ein Zeichen
 bne.s editkc2                  * weniger eingefgt, so da Ins-Marke
 subq.l #1,d0                   * automatisch verschwindet
editkc2:
 cmpa.l a2,a3                   * Wenn Ziel vor dem Block liegt, so werden
 bhi.s editkc3                  * die Blockadressen verschoben, da sie ja
 adda.l d0,a1                   * durchs Einfgen verschoben werden
 adda.l d0,a2
editkc3:
 move.l d0,d1                   * Anzahl der Zeichen nach d1
 bsr einschub                   * Einfgen
 movea.l a1,a0                  * Quelle
editkc4:
 move.b (a0)+,(a3)+             * bertragen
 cmpa.l a0,a2                   * Bis Ende Block erreicht ist
 bhi.s editkc4
bra carres                      * OK, alles richtig ausgefhrt
                                * Ist wichtig fr editkv und editkc
editkc5:
 cmp.b #blkins,(a3)             * 'blkins' an aktueller Stelle ?
 bne editkw3                    * Nein, weiter
 move.b #' ',(a3)               * Ja, deshalb mit Leerzeichen berschreiben
bra editkw3                     * Ende

editkd:                         * Block drucken
 move.b insl(a5),d0
 and.b  #%110,d0
 cmp.b  #%110,d0
 bne    carset                  * Kein Block markiert
 move.b curx(a5),-(a7)
 move.b cury(a5),-(a7)
 bsr savescreen                 * Screen in Speicher
 bsr getblock                   * Block-Adressen holen
 lea    1(a1),a0                * Von dort ab drucken
 move.l stxtxt(a5),-(a7)
 move.l a0,stxtxt(a5)           * Anfang des Textes nicht ndern
 clr.b  (a2)
 bsr    drmenr                  * Ausdrucken mit Einstellungen
 bsr    locrlf                  * Eine Zeile Vorschub
 move.b #blkende,(a2)
 move.l (a7)+,stxtxt(a5)
bra     editkw3

editkf:                         * Einstellungen speichern
 bsr    dostest                 * DOS vorhanden ?
 bcs    carset
 lea    saeddt1(pc),a0          * Frage-Text
 bsr    editabuf
 bcs    edits1buf               * Fehler bei der Eingabe
 bsr    saveed0                 * Abspeichern
bra     edits1buf               * Alte Seite

editkg:                         * Einstellungen laden
 bsr    dostest
 bcs    carset
 lea    loeddt1(pc),a0
 bsr    editabuf
 bcs    edits1buf
 move.b curx(a5),-(a7)          * Position merken
 move.b cury(a5),-(a7)
 bsr    savescreen              * Screen abspeichern
 lea    einbuf+90(a5),a0
 bsr    loaded0                 * Laden
bra editkw3                     * Screen wieder holen

editki:
 bsr dostest                    * Test, ob DOS vorhanden
 bcs carset
 lea disktxt(pc),a0
 bsr editabuf                   * Laufwerk holen
 bcs edits1buf                  * Dann Ende
 move.b curx(a5),-(a7)
 move.b cury(a5),-(a7)
 bsr savescreen                 * Screen abspeichern
 lea    einbuf+90(a5),a1
 bsr catalog                    * Inhaltsverzeichnis ausgeben
bra editkw3                     * Screen wieder holen

editkk:                         * Block-Ende markieren
 btst.b #2,insl(a5)             * Marke gesetzt ?
 beq.s editkk1                  * Nein, weiter
 bsr markeweg                   * Ja, alle Marken lschen
editkk1:
 bset.b #2,insl(a5)             * Merker, da Marke gesetzt
 moveq #blkende,d0              * Zeichen fr Block-Ende
 bsr inschar                    * Zeichen einfgen
bra charoscr                    * Marke ausgeben

editkl:                         * Block von Disk lesen
 bsr dostest                    * Test, ob DOS vorhanden
 bcs carset
 lea nametxt2(pc),a0
 bsr editabuf                   * Namen des Files holen
 bcs edits1buf                  * Fehler
 bsr getflen                    * Lnge des Files holen
 bcs edits1buf                  * Fehler
 bsr editadr                    * Adresse des Cursors holen
 lea 0(a3,d1.l),a2              * Endadresse des einzufgenden Bereichs
 move.l d1,d7
 bsr putscreen                  * Screen in Speicher
 move.l a3,akttxt(a5)           * Ziel des Blocks ist akttxt
 move.l d7,d0
 bsr einschub                   * Einfgen
 movea.l a3,a0                  * Ziel
 bsr tload                      * Block laden
 movea.l a3,a0                  * Alte Adresse
 bcs.s editkl2                  * Fehler
editkl1:
 tst.b (a0)+                    * Ende-Null suchen
 bne.s editkl1                  * Schleife
 subq.l #1,a0                   * Ein Zeichen weniger wegen (a0)+
editkl2:
 move.l a0,akttxt(a5)           * Ist jetzt aktuelle Adresse
 movea.l a2,a0                  * Von dort an schieben, wurde oben berechnen
 cmp.b #blkins,(a0)             * Wenn Ins-Marke gesetzt,
 bne.s editkl3                  * dann ein Zeichen mehr lschen,
 addq.l #1,a0                   * dann ist Ins-Marke gelscht
editkl3:
 bsr clrram                     * Lschen
 lea 1(a3),a0                   * Adresse, wo Block eingefgt wurde
 bsr ptzurueck                  * An Anfang der Zeile
 move.l a0,akttxt(a5)           * Ist aktuelle Adresse
bra getscreen                   * Screen holen

editkp:                         * Font laden
 bsr    dostest
 bcs    carset
 lea    loftdt1(pc),a0
 bsr    editabuf
 bcs    edits1buf
 move.b curx(a5),-(a7)          * Position merken
 move.b cury(a5),-(a7)
 bsr    savescreen              * Screen abspeichern
 lea    einbuf+90(a5),a0
 bsr    loadft0                 * Laden
bra editkw3                     * Screen wieder holen

editkq:                         * Ende
 addq.l #4,a7                   * Stack reinigen
 bsr editkx0
 move.b (a7)+,cotempo(a5)       * Alte Scroll-Geschwindigkeit
 move.b (a7)+,optflag(a5)       * Schriftart wiederherstellen
 moveq #$ff,d0                  * Kennung fr KQ
bra carres

editkr:                         * Block lesen
 lea quelltxt(pc),a0
 bsr editzahl                   * Adresse holen
 bcs carset                     * Fehler
 cmp.l stxtxt(a5),d0            * Liegt Quelladresse innerhalb
 bmi.s editkr0                  * des Editorbereichs ?
 cmp.l etxtxt(a5),d0            * Wenn ja, dann Ende
 bmi carset
editkr0:
 movea.l d0,a4
 tst.b (a4)                     * Wenn leer, dann Ende
 beq carset
 bsr editadr                    * Adresse Cursorposition holen
 bsr putscreen                  * Screen im Ram ablegen
 movea.l a4,a0
editkr1:
 tst.b (a0)+                    * Lnge des Quellblocks feststellen
 bne.s editkr1                  * Bis Null
 suba.l a4,a0                   * Lnge des Blocks
 move.l a0,d0                   * Nach d0
 subq.l #1,d0                   * -1 wegen (a0)+
 cmp.b #blkins,(a3)             * Ins-Marke gesetzt ?
 bne.s editkr2                  * Nein, dann weiter
 subq.l #1,d0                   * Sonst 1 Byte weniger einfgen, dann ist
editkr2:                        * Ins-Marke verschwunden
 tst.l d0
 beq.s editkr3                  * Nichts einfgen
 move.l a3,akttxt(a5)           * Ziel
 bsr einschub                   * Einfgen
editkr3:
 lea 1(a3),a0                   * Ziel
 bsr ptzurueck                  * Adresse auf Anfang der Zeile
 move.l a0,akttxt(a5)           * Adresse merken
editkr4:
 move.b (a4)+,d0                * bertragen Quelle nach d0
 beq getscreen                  * Wenn Null, dann Screen holen
 move.b d0,(a3)+                * Wert in Editor eintragen
bra.s editkr4                   * Schleife

editks:                         * Block auf Diskette schreiben
 bsr dostest                    * Test, ob DOS vorhanden
 bcs carset
 move.b insl(a5),d0
 and.b #%110,d0
 cmp.b #%110,d0
 bne carset                     * Ende, da kein Block markiert ist
 bsr savescreen                 * Screen in Speicher
 move.b curx(a5),-(a7)
 move.b cury(a5),-(a7)
 bsr getblock                   * Blockadressen holen
 bcs editkw3
 addq.l #1,a1                   * Anfangsmarke nicht mit abspeichern
 clr.b (a2)                     * Ende
 movea.l a1,a3                  * Anfang
 lea nametxt1(pc),a0
 bsr editabuf                   * Namen des Files holen
 bcs.s editks1                  * Fehler
 movea.l a3,a0                  * Adresse
 bsr tsave                      * Speichern (Fehlermeldung erfolgt direk)
editks1:
 move.b #blkende,(a2)           * Endemarke wieder setzen
bra editkw3                     * Screen einrichten

editkt:                         * Sicherheitskopie auf Diskette
 bsr dostest                    * Test, ob DOS vorhanden
 bcs carset
 lea nametxt1(pc),a0
 bsr editabuf                   * Namen holen
 bcs edits1buf
 move.b curx(a5),-(a7)
 move.b cury(a5),-(a7)
 bsr savescreen                 * Screen in Speicher
 bsr markrweg                   * Marken entfernen
 movea.l stxtxt(a5),a0          * Dort ist Anfang Text
 bsr tsave                      * Abspeichern (Fehlermeldung erfolgt direkt)
bra editkw3

editkv:                         * Block verschieben
 bsr editkc0                    * Block kopieren
 bcs carset
 move.l a1,akttxt(a5)
 movea.l a2,a0
 bsr clrram                     * Alten Block lschen
 cmpa.l a2,a3
 bls.s editkv1                  * Wenn gelschter Block hinter Screen, dann OK
 suba.l d1,a3                   * Sonst akttxt verschieben
editkv1:
 lea 1(a3),a0
 suba.l d1,a0
 bsr ptzurueck                  * Pointer auf Anfang Block
 move.l a0,akttxt(a5)
bra getscreen                   * Screen holen

editkw:                         * Block speichern
 move.b insl(a5),d0
 and.b #%110,d0
 cmp.b #%110,d0
 bne carset                     * Ende, da kein Block markiert ist
 bsr savescreen                 * Screen in Speicher
 move.b curx(a5),-(a7)
 move.b cury(a5),-(a7)
 bsr getblock                   * Blockadressen holen
 bcs.s editkw3                  * Fehler
 lea 1(a1),a3                   * a3 ist Anfang Block
 subq.l #1,a2                   * Ende Block
 cmpa.l a2,a3
 bhi.s editkw3                  * Block ist leer oder falsch markiert
 lea zieltxt(pc),a0
 bsr editzahl                   * Zieladresse holen
 bcs.s editkw3                  * Fehler
 movea.l d0,a0
 cmp.l stxtxt(a5),d0            * Liegt Zieladresse innerhalb
 bmi.s editkw1                  * des Editorbereichs ?
 cmp.l etxtxt(a5),d0            * Wenn ja, dann Ende
 bmi.s editkw3
editkw1:
 add.l a2,d0                    * Ende des Blocks bestimmen
 sub.l a3,d0                    * Ende Block, wenn abgespeichert
 cmp.l stxtxt(a5),d0            * Liegt Ende des Blocks im Editorbereich ?
 bmi.s editkw2                  * Ja, dann auch Ende
 cmp.l etxtxt(a5),d0
 bmi.s editkw3
editkw2:
 move.b (a3)+,(a0)+             * bertragen
 cmpa.l a3,a2                   * Bis Ende Block
 bpl.s editkw2
 clr.b (a0)                     * Ende setzen
editkw3:
 bsr getscreen                  * Screen holen
 move.b (a7)+,cury(a5)          * Alte Cursorposition
 move.b (a7)+,curx(a5)
bra carset                      * Fehleranzeige fr editkv

editkx:                         * Ende
 addq.l #4,a7                   * Stack reinigen
 bsr.s editkx0
 move.b (a7)+,cotempo(a5)       * Alte Scroll-Geschwindigkeit
 move.b (a7)+,optflag(a5)       * Schrifart wiederherstellen
 moveq #0,d0                    * Kennung fr KX
bra carres

editkx0:
 bsr putscreen                  * Screen in Speicher
 bsr initdebug                  * Debug neu initialisieren
editkx1:
 bsr clrall                     * Immer Bildschirm lschen
 clr.b curon(a5)                * Kein Cursor aktiv
 clr.b flip(a5)                 * Keine Seitenumschaltung
bra markrweg                    * Marken im Ram entfernen

editky:                         * Block lschen
 move.b insl(a5),d0
 and.b #%110,d0
 cmp.b #%110,d0
 bne carset                     * Ende, wenn kein Block vorhanden
 move.b curx(a5),-(a7)
 move.b cury(a5),-(a7)
 bsr savescreen                 * Screen in Speicher
 bsr getblock                   * Blockadressen holen
 bcs.s editkw3                  * Fehler
 addq.l #4,a7                   * Cursorposition ist unwichtig
 move.l a1,akttxt(a5)
 addq.l #1,a2                   * Endemarke auch lschen
 movea.l a2,a0
 bsr clrram                     * Block lschen
 movea.l akttxt(a5),a0
 addq.l #1,a0
 bsr ptzurueck                  * An Blockanfang setzen
 move.l a0,akttxt(a5)           * akttxt setzen
 and.b #%11111001,insl(a5)      * Keine Block-Marken mehr vorhanden
bra getscreen                   * Screen holen

editctl:                        * QA und QF wiederholen
 tst.b ausbuf(a5)
 beq carres                     * Kein Ctrl-L
 tst.b ausbuf+90(a5)            * Ersetzeflag Null ?
 beq suchedit                   * Dann nur suchen
bra sucherse                    * Sonst Suchen und Ersetzen

editctm:                        * Ctrl-M (CR)
 bsr editctx
 btst.b #0,insl(a5)
 bne.s editctn                  * Zeile einfgen, da Einfgemode an ist
editqs:                         * An Zeilenanfang
 btst.b #4,insl(a5)
 beq.s editctm3                 * Ende, wenn ohne Autotab
 move.b cury(a5),d2             * Auf Cursorzeile
editctm0:
 move.b lrand(a5),curx(a5)      * Ab dort suchen
 move.b d2,d0
 bsr getline                    * Zeileninfo holen
 cmp.b #$7f,(a2)
 beq.s editctm2                 * Wenn Leerzeile
 move.b (a1),d0                 * Maximale Zeichenzahl
editctm1:
 cmp.b #' ',(a2)+               * Ende, wenn kein Leerzeichen
 bne.s editctm4
 addq.b #1,curx(a5)             * Nach rechts
 cmp.b curx(a5),d0
 bhi.s editctm1                 * Weiter, wenn noch nicht Zeilenende
editctm2:
 subq.b #1,d2
 bpl.s editctm0                 * Zeile hoch, wenn nicht schon ganz oben
editctm3:
 move.b lrand(a5),curx(a5)      * Auf linken Rand
editctm4:
rts

editctn:                        * Ctrl-N
 moveq #23,d0
 bsr getplatz                   * Platz schaffen zum Einfgen der Zeile
 move.l akttxt(a5),-(a7)        * akttxt nicht ndern
 moveq #23,d0
 bsr zeiscrsp                   * Zeile in den Speicher
 move.l (a7)+,akttxt(a5)
 bsr insline                    * Zeile einfgen
 bsr.s editqs                   * An Zeilenanfang
bra crtstatus                   * Statuszeile neu

editcto:                        * Ctrl-O (Tab links)
 lea    edittabs(a5),a0         * Adresse der Tabs
 moveq  #0,d0
 move.b curx(a5),d0             * Cursorposition
 adda.l d0,a0                   * Adresse des Tab
 clr    d1                      * Zhler fr Sprung
editcto0:
 addq   #1,d1                   * 1 vor
 subq   #1,d0                   * Nchste Position
 bpl.s  editcto1                * Weiter, wenn nicht vorne
rts
editcto1:
 tst.b  -(a0)
 bpl.s  editcto0                * Weitersuchen, da nicht Tab
 sub.b d1,curx(a5)              * Neue Cursorposition
bra adjcurx                     * Zeilenende-Test

editctp:                        * Ctrl-P
 btst.b #6, keydil(a5)          * GDP-FPGA da?
 bne.s editctp2                 * ja, dann auch user Zeichensatz
 eori.b #1, optflag(a5)
 bra.s editctp1
editctp2:
 addq.b #1,optflag(a5)          * einen Zeichensatz weiter
 cmp.b #3,optflag(a5)           * schon bei 3?
 blt.s editctp1                 * nein, dann OK
 clr.b optflag(a5)              * sonst wieder amerikanisch
editctp1:
bra crtstatus                   * Statuszeile ausgeben

editctq:                        * Ctrl-Q
 bsr    ci                      * Zeichen holen
 and.b  #%11111,d0              * Ctrl, Gro- und Kleinschreibung erlaubt
 cmp #24,d0
 bhi carset                     * Nicht grer als 24
 add    d0,d0
 move edctqtab(pc,d0.w),d0
jmp edctqtab(pc,d0.w)           * Unterprogramm aufrufen

edctqtab:
 dc.w carset-edctqtab
 dc.w editqa-edctqtab           * Suchen + Ersetzen
 dc.w carset-edctqtab
 dc.w editqc-edctqtab           * An Textende
 dc.w editcts3-edctqtab         * An Zeilenende
 dc.w ctr2a-edctqtab            * Home
 dc.w editqf-edctqtab           * Suchen
 dc.w carset-edctqtab
 dc.w carset-edctqtab
 dc.w carset-edctqtab
 dc.w carset-edctqtab
 dc.w carset-edctqtab
 dc.w carset-edctqtab
 dc.w carset-edctqtab
 dc.w carset-edctqtab
 dc.w carset-edctqtab
 dc.w carset-edctqtab
 dc.w carset-edctqtab
 dc.w editqr-edctqtab           * An Textanfang
 dc.w editqs-edctqtab           * An Zeilenanfang
 dc.w editqt-edctqtab           * Zeile trennen
 dc.w carset-edctqtab
 dc.w editqv-edctqtab           * Zeile verschmelzen
 dc.w carset-edctqtab
 dc.w editqx-edctqtab           * Auf unterste Zeile

editqa:
 clr.b ausbuf+90(a5)            * Kein Ersetzen
 lea sutxt(pc),a0               * Text
 lea ausbuf(a5),a1              * Ziel
 move #180,d2
 bsr editab0                    * Suchtext holen
 bcs.s  editqf1                 * Fehler
 lea ertxt(pc),a0
 lea ausbuf+42(a5),a1
 moveq #100,d2
 bsr editebuf                   * Ersetzetext holen
 st ausbuf+90(a5)               * Ersetzen aktiv
 bsr sucherse                   * Jetzt Suchen und Ersetzen
bra crtstatus

editqc:
 bsr putscreen                  * Screen in Speicher
 movea.l etxtxt(a5),a0          * Endadresse
 moveq #15-1,d0
editqc1:
 bsr ptzurueck                  * Pointer eine Zeile zurck
 bcc.s editqc2                  * Falls Anfang Text erreicht
 addq.l #1,a0                   * a0 immer dort halten
editqc2:
dbra d0,editqc1
 move.l a0,akttxt(a5)           * Ist Anfangsadresse Screen
bra getscreen                   * Screen holen

editqf:
 clr.b ausbuf+90(a5)            * Kein Ersetzen
 lea sutxt(pc),a0
 lea ausbuf(a5),a1              * Ziel
 moveq  #125,d2
 bsr    editab0                 * Text holen
 bcs.s  editqf1
 bsr    edits1buf               * Alte Seite
bra     suchedit                * Suchen
editqf1:
 clr.b  (a1)                    * Kein Text gltig
bra     edits1buf               * Bildschirm wieder alte Seite

editqr:
 bsr putscreen                  * Screen in Speicher
editqr1:
 move.l stxtxt(a5),akttxt(a5)   * Anfang ist aktuelle Adresse
bra getscreen                   * Screen holen

editqt:                         * Zeile trennen
 move.b curx(a5),-(a7)
 bsr    calccur                 * Zeileninfo holen
 movea.l a2,a3                  * a3 = Zeiger auf aktuelle Position
 lea    80(a0),a4               * Zeiger hinter die Zeile
 addq.b #1,cury(a5)
 bsr    editctn                 * Zeile einfgen
 bsr    calccur                 * Zeileninfo holen
editqt0:
 move.b (a3)+,(a0)+
 cmpa.l a3,a4
 bne.s  editqt0                 * Bis Ende der Zeile bertragen
 bsr    editcts3                * Zeichen pro Zeile richtig einstellen
 clr.b  curx(a5)                * Fr Zeilenausgabe ganz an Anfang
 bsr    lineaus                 * Neue Zeile ausgeben
 subq.b #1,cury(a5)             * Auf alte Zeile
 move.b (a7)+,curx(a5)
bra     eraeoln                 * Ende der Zeile lschen

editqv:                         * Zeile verschmelzen
 bsr    editcts3                * Cursor ans Ende der Zeile
 move.b #80,d1
 sub.b (a1),d1                  * Anzahl der freien Zeichen
 movea.l a2,a3                  * Cursorposition
 addq.b #1,cury(a5)
 bsr    calccur
 move.b curx(a5),-(a7)
 clr.b  curx(a5)
 movea.l a0,a4                  * Adresse nchste Zeile
editqv1:
 move.b (a4),(a3)+
 bsr    delchar
 subq.b #1,d1
 bne.s editqv1
 subq.b #1,cury(a5)
 bsr    editcts3                * Anzahl Zeichen richtig
 move.b (a7)+,curx(a5)
bra    lineaus

editqx:                         * Auf unterste Zeile
 clr.b  curx(a5)
 move.b #22,cury(a5)
rts

editcts:                        * Zeichen links
 move.b lrand(a5),d0
 cmp.b curx(a5),d0              * Cursor am linken Rand ?
 beq.s editcts1                 * Ja, dann weiter
 subq.b #1,curx(a5)             * Sonst nur nach links
rts
editcts1:
 tst.b cury(a5)                 * Weiter, wenn in oberster Zeile
 beq.s editcts2
 subq.b #1,cury(a5)             * Sonst eine Zeile hoch
bra.s   editcts3                * Hinter letztes Zeichen
editcts2:
 bsr    crtdown                 * Scrollen
editcts3:
 move.b #79,curx(a5)
bra     curtoend                * Hinter letztes Zeichen

editctv:                        * Ctrl-V
 eori.b #1,insl(a5)             * Einfgemode umschalten
bra crtstatus                   * Statuszeile neu ausgeben

editctw:                        * Ctrl-W
 bsr crtdown                    * Immer Scrollen
 cmp.b #22,cury(a5)             * Ist Cursor am untersten Rand angelangt ?
 bcc.s editctw0                 * Ja, dann Ende
 addq.b #1,cury(a5)             * Sonst Cursor runter
editctw0:
rts

editctx:                        * Ctrl-X
 cmp.b #21,cury(a5)             * Cursor unten ?
 bhi.s editctx1                 * Ja, dann mu gescrollt werden
 addq.b #1,cury(a5)             * Sonst nur Cursor runter
bra curtoend                    * Mit Endabfrage
editctx1:
 bsr crtup                      * Scrollen
bra curtoend                    * Endabfrage

editcty:                        * Ctrl-Y
 bsr.s  editcty1
bra     crtstatus               * Statuszeile neu

editcty1:
 bsr delline                    * Zeile, auf der Cursor steht, lschen
 movea.l akttxt(a5),a0          * Aktuelle Adresse holen
 moveq #23,d0                   * Auf Zeile 23
 bsr zeispscr                   * Zeile vom Speicher auf den Screen
 move.b cury(a5),-(a7)
 move.b #23,cury(a5)            * Auf Zeile 23
 bsr lineaus                    * Zeile auch auf den Bildschirm
 move.b (a7)+,cury(a5)
 bsr clrram                     * Ram verschieben
bra adjcurx1

editctz:                        * Ctrl-Z
 bsr crtup                      * Scrollen
 tst.b cury(a5)                 * Cursor ganz oben ?
 beq carres                     * Ja, dann Ende
 subq.b #1,cury(a5)             * Sonst Cursor auch nach oben
rts

editesc:                        * ESC-Funktionen
 bsr ci
 cmp.b #'A'-1,d0
 bhi.s edite2                   * Grer als A, dann normale Funktion
 sub.b  #'0',d0
 cmp.b  #9,d0
 bhi    carset                  * Falsche Nummer
 mulu   #41,d0
 lea    editmacro(a5),a3
 adda.l d0,a3                   * Adresse des Textes
 bsr    calccur                 * Zeileninfo holen
 cmpa.l a0,a2
 beq.s  edite0                  * Cursor ist ganz vorne
 cmp.b  #'',(a0)               * Wenn $7f am Anfang einer Zeile
 bne.s  edite0                  * dann weiter
 move.b curx(a5),d4             * Position merken
 clr.b  curx(a5)                * An Zeilenanfang
 moveq  #' ',d0
 bsr    charoscr                * Zeil aktivieren
 move.b d4,curx(a4)             * Alte Position
edite0:
 move.b (a3)+,d0                * Nchstes Zeichen holen
 beq    carset
 btst.b #0,insl(a5)
 beq.s  edite1
 bsr    inschar                 * Bei Einfgemode Zeichen einfgen
edite1:
 bsr    charoscr
bcc.s   edite0                  * Nur wenn noch Platz
rts

edite2:                         * Alle anderen ESC-Funktionen
 and.b  #%11111,d0              * Ctrl, Gro- und Kleinschreibung erlaubt
 cmp #23,d0
 bhi carset                     * Nicht grer als 22
 add    d0,d0
 move edesctab(pc,d0.w),d0
jmp edesctab(pc,d0.w)           * Unterprogramm aufrufen

edesctab:
 dc.w carset-edesctab
 dc.w editea-edesctab           * Alter Text
 dc.w carset-edesctab
 dc.w editec-edesctab           * Tabulatoren lschen
 dc.w edited-edesctab           * Definiere Macro
 dc.w carset-edesctab
 dc.w carset-edesctab           * Macrofunktion ???
 dc.w carset-edesctab
 dc.w carset-edesctab
 dc.w editei-edesctab           * Init Tabulatoren
 dc.w carset-edesctab
 dc.w carset-edesctab
 dc.w editel-edesctab           * Linker Rand
 dc.w editem-edesctab           * Init Macros
 dc.w editen-edesctab           * Neuer Text
 dc.w esc10a-edesctab           * Hardcopy einfach
 dc.w esc11a-edesctab           * Hardcopy mit Zeichensatzumschaltung
 dc.w carset-edesctab
 dc.w carset-edesctab
 dc.w edites-edesctab           * Scrollart
 dc.w editet-edesctab           * Autotab
 dc.w carset-edesctab
 dc.w carset-edesctab
 dc.w editew-edesctab           * Tabulator an/aus

editea:
 bsr savescreen                 * Screen abspeichern
 clr.b flip(a5)                 * Keine Seitenumschaltung
 bsr textalt                    * Adresse alter Text
bra getscreen                   * Neuen Screen laden

editec:                         * Tabulatoren lschen
 lea    edittabs(a5),a0
 moveq  #20-1,d0
editec0:
 clr.l  (a0)+                   * Alle Tabs lschen
dbra    d0,editec0
bra     editei1                 * Anzeige

edited:                         * Macros ausgeben und definieren
 moveq #%10000000,d0            * Seite 2
 bsr    setpage                 * setzen
 bsr    clrinvis                * und lschen
 moveq  #$11,d0                 * Schriftgre
 move   #245,d2
 moveq  #10-1,d3                * 10 Macros
edited0:
 sub    #10,d2                  * Y-Position
 moveq  #9,d4
 sub    d3,d4
 lea    einbuf+90(a5),a0        * Ziel
 move.l #'0 ='*256,(a0)
 add.b  d4,(a0)                 * Nummer
 moveq  #25,d1                  * X = 0
 bsr    textprint               * Ausgabe
 mulu   #41,d4
 lea    editmacro(a5),a0
 adda.l d4,a0                   * Macroadresse
 moveq  #60,d1                  * X-Position
 bsr    textprint               * Macro ausgeben
dbra    d3,edited0              * Nchster Macro
 lea    macrtxt0(pc),a0
 moveq  #$22,d0
 moveq  #110,d2
 bsr    centertxt               * Aufforderungstext
 moveq  #%10100000,d0
 bsr    setpage                 * Seite 2 anzeigen
 bsr    editci                  * Nummer eingeben
 sub.b  #'0',d0
 cmp.b  #'9',d0
 bhi    carset                  * Fehler, da nicht im Bereich 0..9
 mulu   #41,d0
 lea    editmacro(a5),a2
 adda.l d0,a2                   * Zieladresse
 lea    einbuf+90(a5),a1
 lea    macrtxt1(pc),a0
 moveq  #50,d2
 bsr    editbuf1
 bcs    edits1buf               * Ende, wenn leer oder ESC
 bsr    edits1buf               * Alte Seite
edited1:
 move.b (a1)+,(a2)+             * Abspeichern
 bne.s  edited1
rts

editei:                         * Init Tabulatoren
 bsr.s editeiin
editei1:
 bsr    erapen                  * Auf Lschen
 moveq  #1,d1                   * X-Anfang
 move.b #254,gdp+5*cpu.w        * Delta-X
 bsr.s  editei2
 eori.b #1,wrtpage(a5)
 bsr    aktpage                 * Andere Seite
 bsr.s  editei2
 bsr    setpen
bra crtstatus                   * Anzeige der neuen Tabs

editei2:
 moveq  #$10,d0                 * Befehl Vektor zeichnen
 moveq  #12,d2
 bsr    moveto
 bsr    cmd
 bsr    cmd                     * Linie
 addq   #1,d2
 bsr    moveto
 bsr    cmd
bra     cmd                     * Linie

editeiin:                       * Init Tabulatoren
 lea    edittabs(a5),a0
 moveq  #10-1,d0
editei0:
 move.l #$80000000,(a0)+
 clr.l  (a0)+                   * Alle Tabs lschen
dbra    d0,editei0
 clr.b  edittabs(a5)            * Erster nicht
 move.b #$80,-1(a0)             * Letzter schon
rts

editel:
 lea werttxt(pc),a0             * Text
 bsr editzahl                   * Zahl holen
 bcs carset
 and.b #%111111,d0              * 0..63
 move.b d0,lrand(a5)            * Abspeichern
 cmp.b curx(a5),d0
 bmi carset
 move.b d0,curx(a5)             * Wenn links vom Rand, dann auf Rand setzen
rts

editem:                         * Init Macros
 lea    macrotxt(pc),a0         * Dort steht Init-Tabelle
 moveq  #10-1,d0                * 10 Macros (0-9)
editem0:
 moveq  #9,d1
 sub    d0,d1
 mulu   #41,d1                  * Adresse relativ
 lea    editmacro(a5),a1
 adda.l d1,a1                   * Zieladresse fr Macro
editem1:
 move.b (a0)+,(a1)+             * bertragen bis Endekennung
 bne.s  editem1
dbra    d0,editem0              * Nchster Macro
rts

editen:
 bsr savescreen                 * Screen abspeichern
 clr.b flip(a5)                 * Keine Seitenumschaltung
 bsr textneu                    * Adresse neuer Text
bra getscreen                   * Screen laden

edites:
 bchg.b #3,insl(a5)             * Scrollart ndern
bra crtstatus                   * Statuszeile neu ausgeben

editet:                         * Autotab
 bchg.b #4,insl(a5)
bra crtstatus                   * Statuszeile neu

editew:                         * Tabulator ndern
 lea edittabs(a5),a0
 moveq  #0,d0
 move.b curx(a5),d0             * Cursorposition
 bchg.b #7,0(a0,d0.l)
bra     editei1                 * Tabulatoren neu anzeigen


                                                                                                                                                                                                                                                                                                                            